//
//  ShorcutsProviders.swift
//  BooksShelfControlActionStarter
//
//  Created by Giugliano Antonella on 10/03/25.
//
import AppIntents

struct BookShelfShortcutsProvider: AppShortcutsProvider {
    
    static var appShortcuts: [AppShortcut]{
        AppShortcut(
            intent: OpenBookIntent(),
            phrases: [
                "Open a book in \(.applicationName)",
                "Open \(\.$target) in \(.applicationName)",
                "Open \(\.$target) book in \(.applicationName)"
            ],
            shortTitle: "Open a book",
            systemImageName: "book"
        )
        
        AppShortcut(
            intent: AddBookIntent(),
            phrases: [
                "Add a new book in \(.applicationName)",
                "Add a book on my \(.applicationName)",
                "Add a new book on my \(.applicationName)",
                "Put a book on the \(.applicationName)",
                "New book on my \(.applicationName)"
            ],
            shortTitle: "Add a book",
            systemImageName: "book"
        )
    }
}
