//
//  Book.swift
//  BooksShelfControlActionStarter
//
//  Created by Giugliano Antonella on 04/03/25.
//
import SwiftUI
import SwiftData
import AppIntents


@Model
final class Book {
    @Attribute(.unique) var id: UUID = UUID()
    
    var title: String
    var author: String?
    var genre: Genre?
    var contentType: BookContentType?
    var read: Bool = false
    var url: URL? = nil
    
    
    init(title: String, author: String? = nil, genre: Genre? = nil, contentType: BookContentType? = nil, read: Bool = false, url: URL? = nil) {
        self.title = title
        self.author = author ?? "No author"
        self.genre = genre ?? .unspecified
        self.contentType = contentType ?? .physicalBook
        self.read = read
        self.url = url //?? URL(string: "https://www.createwithswift.com/")!
    }
}

enum Genre: String, CaseIterable, Codable, Identifiable, AppEnum {
    case fantasy = "Fantasy"
    case scienceFiction = "Science Fiction"
    case romance = "Romance"
    case mystery = "Mystery"
    case horror = "Horror"
    case selfHelp = "Self Help"
    case biography = "Biography"
    case history = "History"
    case cookbook = "Cookbook"
    
    case unspecified = "Unspecified"
    
    static var typeDisplayRepresentation = TypeDisplayRepresentation(name: "Book Genre")

    static var caseDisplayRepresentations: [Self: DisplayRepresentation] = [
            .fantasy: DisplayRepresentation(title: "Fantasy"),
            .scienceFiction: DisplayRepresentation(title: "Science Fiction"),
            .romance: DisplayRepresentation(title: "Romance"),
            .mystery: DisplayRepresentation(title: "Mystery"),
            .horror: DisplayRepresentation(title: "Horror"),
            .selfHelp: DisplayRepresentation(title: "Self Help"),
            .biography: DisplayRepresentation(title: "Biography"),
            .history: DisplayRepresentation(title: "History"),
            .cookbook: DisplayRepresentation(title: "Cookbook"),
            .unspecified: DisplayRepresentation(title: "Unspecified")
        ]
    
    var id: Self { self }
}

enum BookContentType: String, Codable, CaseIterable, Identifiable, AppEnum{
    case physicalBook = "Physical Book"
    case eBook = "eBook"
    
    static var typeDisplayRepresentation = TypeDisplayRepresentation(name: "Book Type")

    static var caseDisplayRepresentations: [Self: DisplayRepresentation] = [
            .physicalBook: DisplayRepresentation(title: "Physical Book"),
            .eBook: DisplayRepresentation(title: "eBook")
            ]
    
    var id: Self { self }
}

extension Book {
    var entity: BookEntity {
        let entity = BookEntity(item: self)
        return entity
    }
}
